<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Manejar solicitudes OPTIONS para todas las rutas
$routes->options('(:any)', 'Order\OrderController::options');

//RUTAS PARA LOGIN  
$routes->post('auth/login', 'AuthController::login');
$routes->post('auth/logout', 'AuthController::logout');  
$routes->options('auth/login', 'AuthController::options');
$routes->options('auth/logout', 'AuthController::options'); 
$routes->get('auth/forceDestroySession', 'AuthController::forceDestroySession');

//RUTAS PARA ORDERS 
$routes->get('/orders', 'Order\OrderController::index');
$routes->get('/orders/allOrders', 'Order\OrderController::allOrders');
$routes->get('/orders/completedOrders', 'Order\OrderController::completedOrders');
$routes->get('/orders/canceledOrders', 'Order\OrderController::canceledOrders');
$routes->get('/orders/(:num)', 'Order\OrderController::show/$1');
$routes->post('/orders', 'Order\OrderController::create');
$routes->put('/orders/(:num)', 'Order\OrderController::update/$1');
$routes->put('/orders/updateOrder/(:num)', 'Order\OrderController::updateOrder/$1');
$routes->delete('/orders/(:num)', 'Order\OrderController::delete/$1');
$routes->post('/orders/cancel/(:num)', 'Order\OrderController::cancelOrder/$1');
$routes->get('/orders/orderTable/(:num)', 'Order\OrderController::showOrderbyTableNumber/$1');

//RUTAS PARA TABLES 
$routes->get('/tables', 'Table\TableController::index');
$routes->put('/tables/(:num)', 'Table\TableController::updateTableStatus/$1');

// Rutas para la entidad "Category"
$routes->options('/category', 'Category\CategoryController::options');

$routes->get('/category', 'Category\CategoryController::index'); // Obtener todas las categorías
$routes->post('/category', 'Category\CategoryController::create'); // Crear una categoría
$routes->put('/category/(:num)', 'Category\CategoryController::update/$1'); // Actualizar una categoría
$routes->delete('/category/(:num)', 'Category\CategoryController::delete/$1'); // Eliminar una categoría

//RUTAS PARA PRODUCTS
$routes->get('/products', 'Products\ProductsController::index');
$routes->post('products/create', 'Products\ProductsController::create');
$routes->get('/products/byCategory/(:num)', 'Products\ProductsController::getProductsByCategory/$1');
$routes->put('products/update/(:num)', 'Products\ProductsController::updateProduct/$1');
$routes->put('/products/updateAvailability', 'Products\ProductsController::updateAvailability');
$routes->delete('products/delete/(:num)', 'Products\ProductsController::deleteProduct/$1');

$routes->get('/products/productData/(:num)', 'Products\ProductsController::showProductData/$1');

//RUTAS PARA ORDERDETAILS
$routes->get('/orderDetails', 'OrderDetails\OrderDetailsController::index');
$routes->post('/orderDetails', 'OrderDetails\OrderDetailsController::create');
$routes->get('orderDetails/byFk/(:num)', 'OrderDetails\OrderDetailsController::getByFK/$1');
$routes->put('/orderDetails/(:num)', 'OrderDetails\OrderDetailsController::updateNotes/$1');
$routes->delete('/orderDetails/(:num)', 'OrderDetails\OrderDetailsController::delete/$1');
$routes->get('/orderDetails/PendingOrders', 'OrderDetails\OrderDetailsController::getAllPendingOrders');

//RUTAS PARA REPORTS
$routes->get('/reports', 'Reports\ReportsController::bestSellerPrdct');
$routes->get('/reports/Month', 'Reports\ReportsController::bestSellerByMonth');
