<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\HTTP\Response;
use CodeIgniter\API\ResponseTrait;

class AuthController extends BaseController
{
    use ResponseTrait;

    public function __construct()
    {
        // Definir los encabezados CORS para permitir solo el dominio específico
        header('Access-Control-Allow-Origin: https://catchef.bravecatstudios.com');
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        header('Access-Control-Allow-Credentials: true'); 
    }

    public function login()
    {
        $session = session();
        $data = $this->request->getJSON();

        if (!isset($data->Username) || !isset($data->Password)) {
            return $this->fail('Faltan campos obligatorios', 400);
        }

        $userModel = new UserModel();
        $user = $userModel->where('Username', $data->Username)->first();

        if (!$user) {
            return $this->fail('Usuario no encontrado', 401);
        }

        if ($user['IsActive'] == 1) {
            $userModel->update($user['PK_User'], ['IsActive' => 0]);
        }

        if (!password_verify($data->Password, $user['Password'])) {
            return $this->fail('Credenciales inválidas', 401);
        }

        $userModel->update($user['PK_User'], [
            'LastLogin' => date('Y-m-d H:i:s'),
            'IsActive' => 1  
        ]);

        $sessionData = [
            'PK_User' => $user['PK_User'],
            'Username' => $user['Username'],
            'Role' => $user['Role'],
            'IsActive' => 1
        ];
        $session->set($sessionData);

        return $this->respond([
            'message' => 'Login exitoso',
            'PK_User' => $user['PK_User'],
            'Username' => $user['Username'],
            'Role' => $user['Role'],
            'IsActive' => 1
        ], 200);
    }

    public function options()
    {
        header('Access-Control-Allow-Origin: https://catchef.bravecatstudios.com');
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        header('Access-Control-Allow-Credentials: true');  
        return $this->respond('', 200);
    }

    public function logout()
    {
        $session = session();
        $data = $this->request->getJSON();

        if (!isset($data->PK_User)) {
            return $this->fail('Falta el ID de usuario para cerrar sesión.', 400);
        }

        $PK_User = $data->PK_User;
        $userModel = new UserModel();
        $user = $userModel->find($PK_User);

        if (!$user) {
            return $this->fail('Usuario no encontrado', 404);
        }

        $userModel->update($PK_User, [
            'LastLogout' => date('Y-m-d H:i:s'),
            'IsActive' => 0  
        ]);

        $session->destroy();

        return $this->respond(['message' => 'Logout exitoso'], 200);
    }

    public function checkSession()
    {
        $session = session();
        return $this->respond($session->get());
    }
}
