<?php

namespace App\Controllers\Category;

use App\Controllers\BaseController;
use App\Models\Category\CategoryModel;
use CodeIgniter\HTTP\ResponseInterface;
header('Access-Control-Allow-Origin: *'); // Permitir solicitudes desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

class CategoryController extends BaseController
{
    protected $categoryModel;

    public function __construct()
    {
        // Cargar el modelo en el constructor
        $this->categoryModel = new CategoryModel();
    }
    
    public function options()
    {
        // Encabezados CORS
        header('Access-Control-Allow-Origin: *'); // Permitir cualquier origen
        header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS'); // Métodos permitidos
        header('Access-Control-Allow-Headers: Content-Type, Authorization'); // Encabezados permitidos
        header('Access-Control-Max-Age: 86400'); // Tiempo en cache (1 día)
    
        return $this->response->setJSON(['status' => 'ok'], 200);
    }
    
    // Obtener todas las órdenes
    public function index()
    {
        $categories = $this->categoryModel->findAll(); // Obtener todas las órdenes

        return $this->response->setJSON($categories); // Retornar las órdenes en formato JSON
    }

    // Actualizar una orden
    public function updateTableStatus($id)
    {
        // Obtener los datos actualizados desde el cuerpo de la solicitud (JSON)
        $data = $this->request->getJSON();  // Usar getJSON() para manejar JSON

        // Verificar si los datos fueron recibidos correctamente
        if (!$data) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid JSON data']);
        }

        // Intentar actualizar la tabla con el nuevo estado
        if ($this->categoryModel->update($id, (array) $data)) {  // Convierte a array si es un objeto
            return $this->response->setJSON(['status' => 'success', 'message' => 'Table updated successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to update table']);
        }
    }

    public function create()
    {
        // Obtener los datos enviados en el cuerpo de la solicitud
        $data = $this->request->getPost(); // Usar getPost() para manejar datos enviados como formulario
    
        // Validar los datos obligatorios
        if (!isset($data['NameCategory']) || empty($data['NameCategory'])) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'El campo "Nombre de Categoría" es obligatorio.'
            ], ResponseInterface::HTTP_BAD_REQUEST);
        }
    
        // Preparar los datos para la inserción
        $newCategory = [
            'NameCategory' => $data['NameCategory'],
            'CostCategory' => $data['CostCategory'] ?? null,
            'Description'  => $data['Description'] ?? null,
            'IsActive'     => $data['IsActive'] ?? 1,
            'CreatedAt'    => date('Y-m-d H:i:s'),
            'UpdatedAt'    => null,
        ];
    
        // Intentar insertar la categoría
        if ($this->categoryModel->insert($newCategory)) {
            return $this->response->setJSON([
                'status' => 'success',
                'message' => 'Categoría registrada exitosamente.',
                'data' => $newCategory
            ], ResponseInterface::HTTP_CREATED);
        } else {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Hubo un error al registrar la categoría.'
            ], ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
        }
    }
    
    // **Actualizar una categoría**
    public function update($id)
    {
        $data = $this->request->getJSON();  

        if (!$this->categoryModel->find($id)) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Categoría no encontrada.'
            ], ResponseInterface::HTTP_NOT_FOUND);
        }

        if ($this->categoryModel->update($id, (array) $data)) {
            return $this->response->setJSON([
                'status' => 'success',
                'message' => 'Categoría actualizada correctamente.'
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'No se pudo actualizar la categoría.'
            ], ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

    // **Eliminar una categoría**
    public function delete($id)
    {
        if (!$this->categoryModel->find($id)) {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'Categoría no encontrada.'
            ], ResponseInterface::HTTP_NOT_FOUND);
        }

        if ($this->categoryModel->delete($id)) {
            return $this->response->setJSON([
                'status' => 'success',
                'message' => 'Categoría eliminada correctamente.'
            ]);
        } else {
            return $this->response->setJSON([
                'status' => 'error',
                'message' => 'No se pudo eliminar la categoría.'
            ], ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
        }
    }

}
