<?php

namespace App\Controllers\Reports;

use App\Controllers\BaseController;
use App\Models\Reports\BestSellerProductModel;
use App\Models\Reports\BestSellerPrdctByMonthModel;
use CodeIgniter\HTTP\ResponseInterface;
header('Access-Control-Allow-Origin: *'); // Permitir solicitudes desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

class ReportsController extends BaseController
{
    protected $bestSellerModel;
    protected $bestSellerByMonthModel;

    public function __construct()
    {
        // Cargar el modelo en el constructor
        $this->bestSellerModel = new BestSellerProductModel();
        $this->bestSellerByMonthModel = new BestSellerPrdctByMonthModel();
    }
    
    public function options()
    {
        // Encabezados CORS
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        header('Access-Control-Max-Age: 86400'); // Almacenar respuesta en caché por un día

        return $this->response->setJSON(['status' => 'ok'], 200); // Responder con un status OK
    }

    public function bestSellerPrdct()
    {
        $bestPrdct = $this->bestSellerModel->findAll(); // Obtener todas las órdenes

        return $this->response->setJSON($bestPrdct); // Retornar las órdenes en formato JSON
    }

    public function bestSellerByMonth()
    {
        $bestPrdctByMonth = $this->bestSellerByMonthModel->findAll(); // Obtener todas las órdenes

        return $this->response->setJSON($bestPrdctByMonth); // Retornar las órdenes en formato JSON
    }
}