<?php

namespace App\Controllers\Table;

use App\Controllers\BaseController;
use App\Models\Table\TableModel;
use CodeIgniter\HTTP\ResponseInterface;
header('Access-Control-Allow-Origin: *'); // Permitir solicitudes desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

class TableController extends BaseController
{
    protected $tableModel;

    public function __construct()
    {
        // Cargar el modelo en el constructor
        $this->tableModel = new TableModel();
    }
    
    public function options()
    {
        // Encabezados CORS
        header('Access-Control-Allow-Origin: *');
        header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
        header('Access-Control-Allow-Headers: Content-Type, Authorization');
        header('Access-Control-Max-Age: 86400'); // Almacenar respuesta en caché por un día

        return $this->response->setJSON(['status' => 'ok'], 200); // Responder con un status OK
    }
    
    // Obtener todas las órdenes
    public function index()
    {
        $tables = $this->tableModel->findAll(); // Obtener todas las órdenes

        return $this->response->setJSON($tables); // Retornar las órdenes en formato JSON
    }

    // Actualizar una orden
    public function updateTableStatus($id)
    {
        // Obtener los datos actualizados desde el cuerpo de la solicitud (JSON)
        $data = $this->request->getJSON();  // Usar getJSON() para manejar JSON

        // Verificar si los datos fueron recibidos correctamente
        if (!$data) {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Invalid JSON data']);
        }

        // Intentar actualizar la tabla con el nuevo estado
        if ($this->tableModel->update($id, (array) $data)) {  // Convierte a array si es un objeto
            return $this->response->setJSON(['status' => 'success', 'message' => 'Table updated successfully']);
        } else {
            return $this->response->setJSON(['status' => 'error', 'message' => 'Failed to update table']);
        }
    }

}
