<?php

namespace App\Controllers;

use App\Models\UserModel;
use CodeIgniter\API\ResponseTrait;

class UserController extends BaseController
{
    use ResponseTrait;

    public function createTestUser()
    {
        $data = $this->request->getJSON();

        if (!isset($data->Name) || !isset($data->Username) || !isset($data->Password) || !isset($data->Role)) {
            return $this->fail('Faltan campos obligatorios', 400);
        }

        $userModel = new UserModel();

        $newUser = [
            'Name' => $data->Name,
            'Username' => $data->Username,
            'Password' => $data->Password,  
            'Role' => $data->Role,
            'IsActive' => 1,
            'CreatedAt' => date('Y-m-d H:i:s'),
            'UpdatedAt' => date('Y-m-d H:i:s'),
        ];

        if ($userModel->insert($newUser)) {
            return $this->respondCreated(['message' => 'Usuario creado exitosamente para pruebas']);
        } else {
            return $this->fail('Error al crear el usuario', 500);
        }
    }
}
