<?php

namespace App\Models\Category;

use CodeIgniter\Model;

class CategoryModel extends Model
{
    protected $table = 't_category_product'; 
    protected $primaryKey = 'PK_Category'; 

    protected $allowedFields = [
        'NameCategory',
        'CostCategory',
        'Description',
        'CreatedAt',
        'UpdatedAt',
        'IsActive'
    ];

    // Definir el tipo de retorno como array
    protected $returnType = 'array';

    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    // Si usas soft deletes (opcional)
    protected $useSoftDeletes = false;

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}
