<?php

namespace App\Models\Order;

use CodeIgniter\Model;

class OrderModel extends Model
{
    protected $table = 't_order'; 
    protected $primaryKey = 'PK_Order'; 

    protected $allowedFields = [
        'DateOrder',
        'TotalCost',
        'NumCustomers',
        'PaymentType',
        'StatusOrder',
        'TableNumber',
        'CustomerNotes',
        'Discount',
        'CreatedAt',
        'UpdatedAt'
    ];

    // Definir el tipo de retorno como array
    protected $returnType = 'array';

    // Habilitar timestamps automáticos (esto dependerá si manejas los campos created_at y updated_at automáticamente)
    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    // Si usas soft deletes (opcional)
    protected $useSoftDeletes = false;

    // Validaciones opcionales
    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}
