<?php

namespace App\Models\OrderDetails;

use CodeIgniter\Model;

class OrderDetailsModel extends Model
{
    protected $table = 't_details_order';
    protected $primaryKey = 'PK_Details';

    protected $allowedFields = [
        'FK_Order',
        'FK_Product',
        'Quantity',
        'SubTotal',
        'Notes',
        'CreatedAt',
        'UpdatedAt',
        'IsServed'
    ];

    // Definir el tipo de retorno como array
    protected $returnType = 'array';

    // Habilitar timestamps automáticos (esto dependerá si manejas los campos created_at y updated_at automáticamente)
    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    // Si usas soft deletes (opcional)
    protected $useSoftDeletes = false;

    // Validaciones opcionales
    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}