<?php

namespace App\Models\Products;

use CodeIgniter\Model;

class ProductsModel extends Model
{
    protected $table = 't_product'; 
    protected $primaryKey = 'PK_Product'; 

    protected $allowedFields = [
        'NameProduct',
        'FK_Category',
        'CostProduct',
        'DescriptionProduct',
        'Img',
        'IsAvailable',
        'CreatedAt',
        'UpdatedAt'
    ];

    // Definir el tipo de retorno como array
    protected $returnType = 'array';

    // Habilitar timestamps automáticos (esto dependerá si manejas los campos created_at y updated_at automáticamente)
    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    // Si usas soft deletes (opcional)
    protected $useSoftDeletes = false;

    // Validaciones opcionales
    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}
