<?php

namespace App\Models\Table;

use CodeIgniter\Model;

class TableModel extends Model
{
    protected $table = 't_table'; 
    protected $primaryKey = 'PK_Table'; 

    protected $allowedFields = [
        'NumTable',
        'Status',
        'Notes',
        'CreatedAt',
        'UpdatedAt'
    ];

    // Definir el tipo de retorno como array
    protected $returnType = 'array';

    // Habilitar timestamps automáticos (esto dependerá si manejas los campos created_at y updated_at automáticamente)
    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    // Si usas soft deletes (opcional)
    protected $useSoftDeletes = false;

    // Validaciones opcionales
    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
}
