<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 't_user';
    protected $primaryKey = 'PK_User';

    protected $allowedFields = ['Name', 'Username', 'Password', 'Role', 'LastLogin', 'LastLogout', 'IsActive', 'CreatedAt', 'UpdatedAt'];

    protected $useTimestamps = true;
    protected $createdField  = 'CreatedAt';
    protected $updatedField  = 'UpdatedAt';

    protected $returnType    = 'array';

    protected $beforeInsert = ['hashPassword'];
    protected $beforeUpdate = ['hashPassword'];

    protected function hashPassword(array $data)
    {
        if (!isset($data['data']['Password'])) {
            return $data;
        }
        $data['data']['Password'] = password_hash($data['data']['Password'], PASSWORD_BCRYPT);
        return $data;
    }
}
